import 'package:photogram_admin_cp/ui/pages/search/user_search_input.dart';
import 'package:rad/rad.dart';
import 'package:rad/widgets_html.dart';

import 'package:photogram_admin_cp/import/core.dart';

class SideNavigation extends Division {
  SideNavigation({
    required String currentRoute,
    required NavigatorRouteChanger routeChanger,
  }) : super(
          className: 'sidebar',
          child: Division(
            className: 'sidebar-menu',
            children: [
              // search input

              UserSearchInput(routeChanger: routeChanger),

              // items

              SideNavigationLink(
                icon: 'superpowers',
                text: 'Dashboard',
                isActive: 'dashboard' == currentRoute,
                onClick: (event) => routeChanger('dashboard'),
              ),

              const LineBreak(),
              //

              const SideNavigationTitle('Content'),
              const SideNavigationDivider(),

              SideNavigationLink(
                icon: 'upload',
                text: 'Upload Settings',
                isActive: 'uploads' == currentRoute,
                onClick: (event) => routeChanger('uploads'),
              ),

              SideNavigationLink(
                icon: 'database',
                text: 'Storage Options',
                isActive: 'storage' == currentRoute,
                onClick: (event) => routeChanger('storage'),
              ),

              SideNavigationLink(
                icon: 'list-ul',
                text: 'Auto Feed Tweaking',
                isActive: 'aft' == currentRoute,
                onClick: (event) => routeChanger('aft'),
              ),

              const LineBreak(),
              //

              const SideNavigationTitle('Security'),
              const SideNavigationDivider(),

              SideNavigationLink(
                icon: 'exchange',
                text: 'Mailer Settings',
                isActive: 'mailer' == currentRoute,
                onClick: (event) => routeChanger('mailer'),
              ),

              SideNavigationLink(
                icon: 'key',
                text: 'One time Passwords',
                isActive: 'otps' == currentRoute,
                onClick: (event) => routeChanger('otps'),
              ),

              SideNavigationLink(
                icon: 'envelope-o',
                text: 'Email Verification',
                isActive: 'verification' == currentRoute,
                onClick: (event) => routeChanger('verification'),
              ),

              const LineBreak(),
              //

              const SideNavigationTitle('Administration'),
              const SideNavigationDivider(),

              SideNavigationLink(
                icon: 'cog',
                text: 'Site Settings',
                isActive: 'site' == currentRoute,
                onClick: (event) => routeChanger('site'),
              ),

              SideNavigationLink(
                icon: 'lock',
                text: 'Manage Credentials',
                isActive: 'credentials' == currentRoute,
                onClick: (event) => routeChanger('credentials'),
              ),
            ],
          ),
        );
}

class SideNavigationDivider extends Division {
  const SideNavigationDivider() : super(className: 'sidebar-divider');
}

class SideNavigationTitle extends Heading5 {
  const SideNavigationTitle(String title)
      : super(
          className: 'sidebar-title',
          innerText: title,
        );
}

class SideNavigationLink extends Anchor {
  SideNavigationLink({
    required bool isActive,
    required String icon,
    required String text,
    OnTapEventCallback? onClick,
  }) : super(
          onClick: onClick,
          className: 'sidebar-link sidebar-link-with-icon ${isActive ? 'active' : ''}',
          children: [
            Span(
              className: 'sidebar-icon',
              child: Idiomatic(className: 'fa fa-$icon'),
            ),
            Text(text),
          ],
        );
}
